#include <stddef.h>
#include <stdint.h>
#include <string.h>

/* ----------------- Example code from MISRA C:2012 begin ----------------- */

extern char buffer1[ 12 ];
extern char buffer2[ 12 ];

void f1 ( void )
{
  ( void ) strcpy ( buffer1, "abc" );
  ( void ) strcpy ( buffer2, "abc" );

  /* Non-compliant */
  if ( memcmp ( buffer1, buffer2, sizeof ( buffer1 ) ) != 0 )
  {
  }
}

unsigned char headerStart[ 6 ] = {'h', 'e', 'a', 'd', 0, 164};

void f2 ( const uint8_t *packet )
{
  /* Compliant */
  if ( ( NULL != packet ) && ( memcmp ( packet, headerStart, 6 ) == 0 ) )
  {
  }
}

/* ------------------ Example code from MISRA C:2012 end ------------------ */
